////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <ShlOBJ.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <WinSock2.H>
#include <WinSock.H>

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "Headers/NSWFL.H"
#include "Headers/NASCCL.H"

#include "Resources/Resource.H"

#include "SQLClass/Definitions.H"
#include "SQLClass/Functions.H"

#include "Headers/CRC.H"
#include "Headers/Definitions.H"
#include "Headers/SQLExport.H"
#include "Headers/Security.H"
#include "TCP/Class.H"

#include "Headers/Authenticate.H"
#include "Headers/Commands.H"
#include "Headers/ClientThread.H"
#include "Headers/Functions.H"

#include "Headers/Init.H"

#include "Dialogs/Main.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	MainInstance = hInstance;

	HANDLE xMutex = NULL;

    if(!Initialize())
    {
		MessageBox (NULL, "Failed to initialize!", TitleCaption, MB_ICONHAND | MB_SYSTEMMODAL);
		ReleaseMutex(xMutex);
		CloseHandle(xMutex);
		return 1;
    }

	if( (xMutex = OpenMutex(SYNCHRONIZE, FALSE, TitleCaption)) )
	{
		MessageBox (NULL, "Only one instance can run at a time!", TitleCaption, MB_ICONASTERISK + MB_SYSTEMMODAL);
		ReleaseMutex(xMutex);
		CloseHandle(xMutex);
		return 0;
	}
	else xMutex = CreateMutex(0, 0, TitleCaption);

	DialogBox(MainInstance, MAKEINTRESOURCE(IDD_MAIN), 0, MainDialog);

    if(!Uninitialize())
    {
		MessageBox (NULL, "Failed to initialize!", TitleCaption, MB_ICONHAND | MB_SYSTEMMODAL);
		ReleaseMutex(xMutex);
		CloseHandle(xMutex);
		return 1;
    }

    ReleaseMutex(xMutex);
	CloseHandle(xMutex);

	return 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

